<style>
    .header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background-color: #ffffff;
        padding: 15px 40px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }
    .header .logo {
        font-size: 1.5rem;
        font-weight: bold;
        color: #2c3e50;
    }
    .header .logo a {
        text-decoration: none;
        color: inherit;
    }
    .header .nav-links {
        display: flex;
        gap: 25px;
    }
    .header .nav-links a {
        text-decoration: none;
        color: #7f8c8d;
        font-weight: 500;
        transition: color 0.3s;
    }
    .header .nav-links a:hover,
    .header .nav-links a.active {
        color: #3498db;
    }
    .header .user-info {
        display: flex;
        align-items: center;
        gap: 15px;
    }
    .header .user-info span {
        color: #34495e;
        font-weight: bold;
    }
    .header .user-info .logout-btn {
        background-color: #e74c3c;
        color: white;
        padding: 8px 15px;
        border-radius: 5px;
        text-decoration: none;
        transition: background-color 0.3s;
    }
    .header .user-info .logout-btn:hover {
        background-color: #c0392b;
    }
</style>
<?php if(auth()->guard()->check()): ?>

<header class="header">
    <div class="logo">
        <a href="<?php echo e(route('dashboard')); ?>">آریا ورزش</a>
    </div>
    <nav class="nav-links">
        <?php if(Auth::user()->role === 'purchase'): ?>
            <a href="<?php echo e(route('purchases.create')); ?>" class="<?php echo e(Request::routeIs('purchases.create') ? 'active' : ''); ?>">ثبت خرید</a>
            <a href="<?php echo e(route('purchases.index')); ?>" class="<?php echo e(Request::routeIs('purchases.index') ? 'active' : ''); ?>">لیست خریدها</a>
            <a href="<?php echo e(route('suppliers.create')); ?>" class="<?php echo e(Request::routeIs('suppliers.create') ? 'active' : ''); ?>">ثبت تامین‌کننده</a>
        <?php endif; ?>

        <?php if(Auth::user()->role === 'sales'): ?>
            <a href="<?php echo e(route('sales.create')); ?>" class="<?php echo e(Request::routeIs('sales.create') ? 'active' : ''); ?>">ثبت فروش</a>
            <a href="<?php echo e(route('sales.index')); ?>" class="<?php echo e(Request::routeIs('sales.index') ? 'active' : ''); ?>">لیست فروش‌ها</a>
        <?php endif; ?>
    </nav>
    <div class="user-info">
        <span><?php echo e(Auth::user()->name); ?></span>
        <a href="<?php echo e(route('logout')); ?>" class="logout-btn" 
            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
            خروج
        </a>
        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
            <?php echo csrf_field(); ?>
        </form>
    </div>
</header>
<?php endif; ?><?php /**PATH C:\xampp\htdocs\ariya-varzesh\resources\views/layouts/header.blade.php ENDPATH**/ ?>