<?php

use App\Http\Controllers\SupplierController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\DashboardController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

// مسیر پیش‌فرض برای ورود
Route::get('/', function () {
    return view('auth.login');
})->name('home');
// مسیرهای عمومی
Route::get('/', function () {
    if (Auth::check()) {
        return redirect()->route('dashboard');
    }
    return view('auth.login');
});
Route::middleware('role:purchase')->group(function () {
    Route::get('/suppliers/create', [SupplierController::class, 'create'])->name('suppliers.create');
    Route::post('/suppliers', [SupplierController::class, 'store'])->name('suppliers.store');

    Route::get('/purchases', [PurchaseController::class, 'index'])->name('purchases.index');
    Route::get('/purchases/create', [PurchaseController::class, 'create'])->name('purchases.create');
    Route::post('/purchases', [PurchaseController::class, 'store'])->name('purchases.store');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');



// مسیرهای تیم فروش
Route::middleware('role:sales')->group(function () {
    Route::get('/sales/create', [SaleController::class, 'create'])->name('sales.create');
    Route::post('/sales', [SaleController::class, 'store'])->name('sales.store');
    Route::get('/sales', [SaleController::class, 'index'])->name('sales.index');
    Route::get('/sales/{sale}/finalize', [SaleController::class, 'finalize'])->name('sales.finalize');
    Route::put('/sales/{sale}/update-status', [SaleController::class, 'updateStatus'])->name('sales.updateStatus');
});

// مسیر داشبورد که فقط برای کاربران احراز هویت شده قابل دسترسی است
Route::get('/dashboard', [DashboardController::class, 'index'])->middleware('auth')->name('dashboard');