@extends('layouts.app')

@section('title', 'عنوان صفحه')

@section('styles')
<style>
    body { font-family: 'B Nazanin', sans-serif; background-color: #f4f7f6; margin: 0; padding: 20px; }
    .container { max-width: 900px; margin: 0 auto; background-color: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
    h1 { text-align: center; color: #333; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { border: 1px solid #ddd; padding: 12px; text-align: center; }
    th { background-color: #f2f2f2; color: #555; }
    tr:nth-child(even) { background-color: #f9f9f9; }
    tr:hover { background-color: #f1f1f1; }
    a { text-decoration: none; color: #3498db; font-weight: bold; }
    a:hover { color: #2980b9; }
    .details { font-size: 0.9em; text-align: right; }
</style>
    @endsection

    @section('scripts')
    <script>
        // اینجا کدهای جاوااسکریپت مخصوص این صفحه را قرار دهید
    </script>
    @endsection

    @section('content')


    <div class="container">
        <h1>لیست فروش‌ها</h1>

       <table>
    <thead>
        <tr>
            <th>شناسه</th>
            <th>مشتری</th>
            <th>مبلغ فروش</th>
            <th>ثبت‌کننده</th>
            <th>تخصیص به خرید</th>
            <th>وضعیت</th> <th>تاریخ ثبت</th>
            <th>عملیات</th> </tr>
    </thead>
    <tbody>
        @foreach ($sales as $sale)
            <tr>
                <td>{{ $sale->id }}</td>
                <td>{{ $sale->customer_name }}</td>
                <td>{{ number_format($sale->amount) }}</td>
                <td>{{ $sale->user->name }}</td>
                <td>
                    @foreach($sale->allocations as $allocation)
                        <div class="details">
                            به خرید #{{ $allocation->purchase_id }}: {{ number_format($allocation->allocated_amount) }}
                        </div>
                    @endforeach
                </td>
                <td>
                    @if ($sale->status === 'پرداخت شده')
                        <span style="color: green; font-weight: bold;">{{ $sale->status }}</span>
                    @else
                        <span style="color: orange; font-weight: bold;">{{ $sale->status }}</span>
                    @endif
                </td>
                <td>{{ $sale->created_at->format('Y-m-d') }}</td>
                <td>
                    @if ($sale->status !== 'پرداخت شده')
                        <a href="{{ route('sales.finalize', $sale->id) }}">
                            آپلود رسید و نهایی‌سازی
                        </a>
                    @endif
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
    </div>


    @endsection