@extends('layouts.app')
@section('title', 'نهایی‌سازی فروش')

@section('content')
<div class="container">
    <h1>نهایی‌سازی فروش #{{ $sale->id }}</h1>
    <p>مبلغ فروش: {{ number_format($sale->amount) }} تومان</p>
    <p>مشتری: {{ $sale->customer_name }}</p>

@if (session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
@endif
@if (session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
@endif
@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

    <form action="{{ route('sales.updateStatus', $sale->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
       <div class="form-group">
    <label for="receipt">آپلود رسید پرداخت</label>
    <input type="file" name="receipt" id="receipt" class="form-control" required>
</div>
        <button type="submit" class="btn btn-primary">ثبت و نهایی‌سازی</button>
    </form>
</div>
@endsection

@section('styles')
<style>
    .container { max-width: 600px; margin: 20px auto; padding: 20px; background-color: #fff; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
    h1 { text-align: center; color: #333; }
    .alert { padding: 15px; margin-bottom: 20px; border-radius: 4px; }
    .alert-success { background-color: #d4edda; color: #155724; border-color: #c3e6cb; }
    .alert-danger { background-color: #f8d7da; color: #721c24; border-color: #f5c6cb; }
    .form-group { margin-bottom: 15px; }
    .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
    .form-control { width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px; }
    .btn { display: block; width: 100%; padding: 10px; background-color: #007bff; color: white; text-align: center; border-radius: 4px; text-decoration: none; border: none; cursor: pointer; }
    .btn:hover { background-color: #0056b3; }
</style>
@endsection