<!DOCTYPE html>
<html lang="fa" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ثبت فروش جدید</title>
    <style>
        body {
            font-family: 'B Nazanin', sans-serif;
            background-color: #f4f7f6;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0;
        }

        .form-container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            width: 600px;
            max-height: 90vh;
            overflow-y: auto;
        }

        h1 {
            text-align: center;
            color: #2c3e50;
            margin-bottom: 30px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #555;
        }

        input[type="text"],
        input[type="number"],
        select,
        input[type="file"] {
            width: 100%;
            padding: 12px;
            border: 1px solid #ccc;
            border-radius: 6px;
            box-sizing: border-box;
            font-size: 16px;
        }

        input:focus,
        select:focus,
        input[type="file"]:focus {
            border-color: #3498db;
            outline: none;
            box-shadow: 0 0 5px rgba(52, 152, 219, 0.5);
        }

        .btn-submit {
            width: 100%;
            padding: 15px;
            background-color: #2ecc71;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 18px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .btn-submit:hover {
            background-color: #27ae60;
        }

        .alert {
            padding: 15px;
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
            border-radius: 6px;
            margin-bottom: 20px;
        }

        .error {
            color: #e74c3c;
            font-size: 14px;
            margin-top: 5px;
            display: block;
        }

        .allocation-item {
            border: 1px solid #eee;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            position: relative;
        }

        .remove-allocation {
            position: absolute;
            top: 10px;
            left: 10px;
            background-color: #e74c3c;
            color: white;
            border: none;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            font-size: 18px;
            cursor: pointer;
            line-height: 1;
            text-align: center;
        }

        .add-allocation {
            background-color: #3498db;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            display: block;
            width: 100%;
            margin-top: 10px;
        }
    </style>
</head>

<body>
    <div class="form-container">
        <h1>ثبت فروش جدید</h1>
        @if (session('status'))
        <div class="alert">{{ session('status') }}</div>
        @endif

        @if ($errors->any())
        <div class="alert" style="background-color: #f8d7da; color: #721c24; border-color: #f5c6cb;">
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <form action="{{ route('sales.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="form-group">
                <label for="customer_name">نام مشتری</label>
                <input type="text" id="customer_name" name="customer_name" value="{{ old('customer_name') }}" required>
                @error('customer_name')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label for="amount">مبلغ کل فروش</label>
                <input type="number" id="amount" name="amount" value="{{ old('amount') }}" required min="0">
                @error('amount')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label for="invoice_file">فاکتور فروش (PDF, JPG, PNG)</label>
                <input type="file" id="invoice_file" name="invoice_file">
                @error('invoice_file')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label for="payment_receipt_file">رسید پرداختی مشتری (PDF, JPG, PNG)</label>
                <input type="file" id="payment_receipt_file" name="payment_receipt_file">
                @error('payment_receipt_file')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>

            <h2>اختصاص مبلغ به خریدها</h2>
            <div id="allocations-container">
                @if(old('allocations'))
                @foreach(old('allocations') as $index => $allocation)
                <div class="allocation-item">
                    <button type="button" class="remove-allocation">×</button>
                    <div class="form-group">
                        <label>انتخاب خرید</label>
                        <select name="allocations[{{ $index }}][purchase_id]" required>
                            <option value="">انتخاب کنید...</option>
                            @foreach($purchases as $purchase)
                            <option value="{{ $purchase->id }}" {{ old("allocations.$index.purchase_id") == $purchase->id ? 'selected' : '' }}>
                                خرید از {{ $purchase->supplier->name }} (مبلغ باقیمانده: {{ $purchase->total_amount - $purchase->allocated_amount }})
                            </option>
                            @endforeach
                        </select>
                        @error("allocations.$index.purchase_id")
                        <span class="error">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label>مبلغ اختصاص یافته</label>
                        <input type="number" name="allocations[{{ $index }}][allocated_amount]" value="{{ old("allocations.$index.allocated_amount") }}" required min="0">
                        @error("allocations.$index.allocated_amount")
                        <span class="error">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                @endforeach
                @else
                <div class="allocation-item">
                    <button type="button" class="remove-allocation">×</button>
                    <div class="form-group">
                        <label>انتخاب خرید</label>
                        <select name="allocations[0][purchase_id]" required>
                            <option value="">انتخاب کنید...</option>
                            @foreach($purchases as $purchase)
                            <option value="{{ $purchase->id }}">
                                خرید از {{ $purchase->supplier->name }} (مبلغ باقیمانده: {{ $purchase->total_amount - $purchase->allocated_amount }})
                            </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>مبلغ اختصاص یافته</label>
                        <input type="number" name="allocations[0][allocated_amount]" required min="0">
                    </div>
                </div>
                @endif
            </div>

            <button type="button" class="add-allocation">افزودن تخصیص جدید</button>
            <div class="form-group" style="margin-top: 20px;">
                <button type="submit" class="btn-submit">ثبت فروش</button>
            </div>
        </form>
    </div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        let allocationIndex = {{ count(old('allocations', ['dummy'])) }};

        document.querySelector('.add-allocation').addEventListener('click', function () {
            const container = document.getElementById('allocations-container');
            const newAllocationItem = document.createElement('div');
            newAllocationItem.classList.add('allocation-item');
            
            const purchases = @json($purchases);
            let optionsHtml = '';
            purchases.forEach(purchase => {
                const remainingAmount = purchase.total_amount - (purchase.allocated_amount || 0);
                optionsHtml += `<option value="${purchase.id}">خرید از ${purchase.supplier.name} (مبلغ باقیمانده: ${remainingAmount})</option>`;
            });

            newAllocationItem.innerHTML = `
                <button type="button" class="remove-allocation">×</button>
                <div class="form-group">
                    <label>انتخاب خرید</label>
                    <select name="allocations[${allocationIndex}][purchase_id]" required>
                        <option value="">انتخاب کنید...</option>
                        ${optionsHtml}
                    </select>
                </div>
                <div class="form-group">
                    <label>مبلغ اختصاص یافته</label>
                    <input type="number" name="allocations[${allocationIndex}][allocated_amount]" required min="0">
                </div>
            `;
            container.appendChild(newAllocationItem);
            allocationIndex++;
        });

        document.getElementById('allocations-container').addEventListener('click', function(e) {
            if (e.target.classList.contains('remove-allocation')) {
                if (document.querySelectorAll('.allocation-item').length > 1) {
                    e.target.closest('.allocation-item').remove();
                } else {
                    alert('حداقل یک تخصیص باید وجود داشته باشد.');
                }
            }
        });
    });
</script>
</body>

</html>