<!DOCTYPE html>
<html lang="fa" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ثبت خرید جدید</title>
    <style>
        body {
            font-family: 'B Nazanin', sans-serif;
            background-color: #f4f7f6;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0;
        }

        .form-container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            width: 600px;
            max-height: 90vh;
            overflow-y: auto;
        }

        h1 {
            text-align: center;
            color: #2c3e50;
            margin-bottom: 30px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #555;
        }

        input[type="text"],
        input[type="number"],
        select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ccc;
            border-radius: 6px;
            box-sizing: border-box;
            font-size: 16px;
        }

        input:focus,
        select:focus {
            border-color: #3498db;
            outline: none;
            box-shadow: 0 0 5px rgba(52, 152, 219, 0.5);
        }

        .btn-submit {
            width: 100%;
            padding: 15px;
            background-color: #2ecc71;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 18px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .btn-submit:hover {
            background-color: #27ae60;
        }

        .alert {
            padding: 15px;
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
            border-radius: 6px;
            margin-bottom: 20px;
        }

        .error {
            color: #e74c3c;
            font-size: 14px;
            margin-top: 5px;
            display: block;
        }

        .payment-item {
            border: 1px solid #eee;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            position: relative;
        }

        .remove-payment {
            position: absolute;
            top: 10px;
            left: 10px;
            background-color: #e74c3c;
            color: white;
            border: none;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            font-size: 18px;
            cursor: pointer;
            line-height: 1;
            text-align: center;
        }

        .add-payment {
            background-color: #3498db;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            display: block;
            width: 100%;
            margin-top: 10px;
        }
    </style>
</head>

<body>
    <div class="form-container">
        <h1>ثبت خرید جدید</h1>

        @if (session('status'))
        <div class="alert">{{ session('status') }}</div>
        @endif

        @if ($errors->any())
        <div class="alert" style="background-color: #f8d7da; color: #721c24; border-color: #f5c6cb;">
            <ul>
                @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
        @endif

        <form action="{{ route('purchases.store') }}" method="POST">
            @csrf

            <div class="form-group">
                <label for="supplier_id">تامین‌کننده</label>
                <select id="supplier_id" name="supplier_id" required>
                    <option value="">انتخاب کنید...</option>
                    @foreach ($suppliers as $supplier)
                    <option value="{{ $supplier->id }}" {{ old('supplier_id') == $supplier->id ? 'selected' : '' }}>
                        {{ $supplier->name }}
                    </option>
                    @endforeach
                </select>
                @error('supplier_id')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label for="contact_person">نام کسی که با او صحبت شده</label>
                <input type="text" id="contact_person" name="contact_person" value="{{ old('contact_person') }}" required>
                @error('contact_person')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>

            <div class="form-group">
                <label for="total_amount">مبلغ کل خرید</label>
                <input type="number" id="total_amount" name="total_amount" value="{{ old('total_amount') }}" required min="0">
                @error('total_amount')
                <span class="error">{{ $message }}</span>
                @enderror
            </div>

            <h2>واریزی‌ها</h2>
            <div id="payments-container">
                @if(old('payments'))
                @foreach(old('payments') as $index => $payment)
                <div class="payment-item">
                    <button type="button" class="remove-payment">×</button>
                    <div class="form-group">
                        <label>نام صاحب حساب</label>
                        <input type="text" name="payments[{{ $index }}][account_holder_name]" value="{{ $payment['account_holder_name'] }}" required>
                        @error("payments.$index.account_holder_name")
                        <span class="error">{{ $message }}</span>
                        @enderror
                    </div>
                    <div class="form-group">
                        <label>شماره کارت</label>
                        <input type="text" name="payments[{{ $index }}][card_number]" value="{{ $payment['card_number'] }}">
                    </div>
                    <div class="form-group">
                        <label>شماره شبا</label>
                        <input type="text" name="payments[{{ $index }}][sheba_number]" value="{{ $payment['sheba_number'] }}">
                    </div>
                    <div class="form-group">
                        <label>مبلغ</label>
                        <input type="number" name="payments[{{ $index }}][amount]" value="{{ $payment['amount'] }}" required min="0">
                        @error("payments.$index.amount")
                        <span class="error">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                @endforeach
                @else
                <div class="payment-item">
                    <button type="button" class="remove-payment">×</button>
                    <div class="form-group">
                        <label>نام صاحب حساب</label>
                        <input type="text" name="payments[0][account_holder_name]" required>
                    </div>
                    <div class="form-group">
                        <label>شماره کارت</label>
                        <input type="text" name="payments[0][card_number]">
                    </div>
                    <div class="form-group">
                        <label>شماره شبا</label>
                        <input type="text" name="payments[0][sheba_number]">
                    </div>
                    <div class="form-group">
                        <label>مبلغ</label>
                        <input type="number" name="payments[0][amount]" required min="0">
                    </div>
                </div>
                @endif
            </div>

            <button type="button" class="add-payment">افزودن واریزی جدید</button>
            <div class="form-group" style="margin-top: 20px;">
                <button type="submit" class="btn-submit">ثبت خرید</button>
            </div>
        </form>
    </div>

  <script>
    document.addEventListener('DOMContentLoaded', function () {
        // اطمینان از مقداردهی صحیح paymentIndex
        let paymentIndex = {{ old('payments') ? count(old('payments')) : 1 }};

        document.querySelector('.add-payment').addEventListener('click', function () {
            const container = document.getElementById('payments-container');
            const newPaymentItem = document.createElement('div');
            newPaymentItem.classList.add('payment-item');
            newPaymentItem.innerHTML = `
                <button type="button" class="remove-payment">×</button>
                <div class="form-group">
                    <label>نام صاحب حساب</label>
                    <input type="text" name="payments[${paymentIndex}][account_holder_name]" required>
                </div>
                <div class="form-group">
                    <label>شماره کارت</label>
                    <input type="text" name="payments[${paymentIndex}][card_number]">
                </div>
                <div class="form-group">
                    <label>شماره شبا</label>
                    <input type="text" name="payments[${paymentIndex}][sheba_number]">
                </div>
                <div class="form-group">
                    <label>مبلغ</label>
                    <input type="number" name="payments[${paymentIndex}][amount]" required min="0">
                </div>
            `;
            container.appendChild(newPaymentItem);
            paymentIndex++;
        });

        document.getElementById('payments-container').addEventListener('click', function(e) {
            if (e.target.classList.contains('remove-payment')) {
                if (document.querySelectorAll('.payment-item').length > 1) {
                    e.target.closest('.payment-item').remove();
                } else {
                    alert('حداقل یک واریزی باید وجود داشته باشد.');
                }
            }
        });
    });
</script>
</body>

</html>