<style>
    .header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background-color: #ffffff;
        padding: 15px 40px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }
    .header .logo {
        font-size: 1.5rem;
        font-weight: bold;
        color: #2c3e50;
    }
    .header .logo a {
        text-decoration: none;
        color: inherit;
    }
    .header .nav-links {
        display: flex;
        gap: 25px;
    }
    .header .nav-links a {
        text-decoration: none;
        color: #7f8c8d;
        font-weight: 500;
        transition: color 0.3s;
    }
    .header .nav-links a:hover,
    .header .nav-links a.active {
        color: #3498db;
    }
    .header .user-info {
        display: flex;
        align-items: center;
        gap: 15px;
    }
    .header .user-info span {
        color: #34495e;
        font-weight: bold;
    }
    .header .user-info .logout-btn {
        background-color: #e74c3c;
        color: white;
        padding: 8px 15px;
        border-radius: 5px;
        text-decoration: none;
        transition: background-color 0.3s;
    }
    .header .user-info .logout-btn:hover {
        background-color: #c0392b;
    }
</style>
@auth

<header class="header">
    <div class="logo">
        <a href="{{ route('dashboard') }}">آریا ورزش</a>
    </div>
    <nav class="nav-links">
        @if (Auth::user()->role === 'purchase')
            <a href="{{ route('purchases.create') }}" class="{{ Request::routeIs('purchases.create') ? 'active' : '' }}">ثبت خرید</a>
            <a href="{{ route('purchases.index') }}" class="{{ Request::routeIs('purchases.index') ? 'active' : '' }}">لیست خریدها</a>
            <a href="{{ route('suppliers.create') }}" class="{{ Request::routeIs('suppliers.create') ? 'active' : '' }}">ثبت تامین‌کننده</a>
        @endif

        @if (Auth::user()->role === 'sales')
            <a href="{{ route('sales.create') }}" class="{{ Request::routeIs('sales.create') ? 'active' : '' }}">ثبت فروش</a>
            <a href="{{ route('sales.index') }}" class="{{ Request::routeIs('sales.index') ? 'active' : '' }}">لیست فروش‌ها</a>
        @endif
    </nav>
    <div class="user-info">
        <span>{{ Auth::user()->name }}</span>
        <a href="{{ route('logout') }}" class="logout-btn" 
            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
            خروج
        </a>
        <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
            @csrf
        </form>
    </div>
</header>
@endauth