<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'پروژه آریای ورزش')</title>
    <style>
        @font-face {
            font-family: 'Vazirmatn';
            src: url('{{ asset('fonts/Vazirmatn-Regular.woff2') }}') format('woff2');
            font-weight: normal;
            font-style: normal;
        }
        body {
            font-family: 'Vazirmatn', sans-serif;
            background-color: #f0f2f5;
            margin: 0;
            padding: 0;
        }
        .main-content {
            padding: 20px;
            min-height: calc(100vh - 60px); /* Adjust based on header height */
        }
    </style>
    @yield('styles')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>
<body>
    @include('layouts.header')

    <div class="main-content">
        @yield('content')
    </div>

    @yield('scripts')
</body>
</html>