<!DOCTYPE html>
<html lang="fa" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>داشبورد</title>
    <style>
        body {
            font-family: 'B Nazanin', sans-serif;
            background-color: #f4f7f6;
            margin: 0;
            padding: 20px;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            background-color: #fff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            color: #2c3e50;
        }

        .card-grid {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
            justify-content: center;
            margin-top: 30px;
        }

        .card {
            background-color: #ecf0f1;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            width: 220px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .card h2 {
            color: #34495e;
            font-size: 1.2em;
            margin-top: 0;
        }

        .card p {
            font-size: 2em;
            font-weight: bold;
            color: #3498db;
            margin: 10px 0 0;
        }

        .role-section {
            margin-top: 40px;
        }

        .links-container {
            text-align: center;
            margin-top: 30px;
        }

        .links-container a {
            display: inline-block;
            padding: 12px 25px;
            margin: 0 10px;
            background-color: #2ecc71;
            color: white;
            border-radius: 5px;
            text-decoration: none;
            font-weight: bold;
            transition: background-color 0.3s;
        }

        .links-container a:hover {
            background-color: #27ae60;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>داشبورد {{ Auth::user()->role === 'purchase' ? 'تیم خرید' : 'تیم فروش' }}</h1>

        <div class="card-grid">
            @if (Auth::user()->role === 'purchase')
            <div class="card">
                <h2>مجموع خریدها</h2>
                <p>{{ number_format($data['totalPurchases'] ?? 0) }} تومان</p>
            </div>
            <div class="card">
                <h2>مجموع پرداخت‌ها</h2>
                <p>{{ number_format($data['totalAllocations'] ?? 0) }} تومان</p>
            </div>
            <div class="card">
                <h2>خریدهای در انتظار</h2>
                <p>{{ $data['pendingPurchases'] ?? 0 }}</p>
            </div>
            @endif

            @if (Auth::user()->role === 'sales')
            <div class="card">
                <h2>مجموع فروش‌ها</h2>
                <p>{{ number_format($data['totalSales'] ?? 0) }} تومان</p>
            </div>
            <div class="card">
                <h2>مجموع تخصیص‌ها</h2>
                <p>{{ number_format($data['totalAllocations'] ?? 0) }} تومان</p>
            </div>
            <div class="card">
                <h2>مبالغ تخصیص نیافته</h2>
                <p>{{ number_format($data['unallocatedSales'] ?? 0) }} تومان</p>
            </div>
            @endif
        </div>

        <div class="links-container">
            @if (Auth::user()->role === 'purchase')
            <a href="{{ route('purchases.create') }}">ثبت خرید جدید</a>
            <a href="{{ route('purchases.index') }}">لیست خریدها</a>
            <a href="{{ route('suppliers.create') }}">ثبت تامین‌کننده</a>
            @endif
            @if (Auth::user()->role === 'sales')
            <a href="{{ route('sales.create') }}">ثبت فروش جدید</a>
            <a href="{{ route('sales.index') }}">لیست فروش‌ها</a>
            @endif
        </div>
    </div>
</body>

</html>