<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Purchase;

class PurchasePayment extends Model
{
    use HasFactory;



    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'purchase_id',
        'account_holder_name',
        'card_number',
        'sheba_number',
        'amount',
    ];


    // یک واریزی متعلق به یک خرید است
    public function purchase(): BelongsTo
    {
        return $this->belongsTo(Purchase::class);
    }
}
