<?php

namespace App\Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use App\Models\Supplier;
use App\Models\PurchasePayment;
use App\Models\SalePurchaseAllocation;

class Purchase extends Model
{
    use HasFactory;


    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'supplier_id',
        'contact_person',
        'total_amount',
        'allocated_amount',
    ];


    // یک خرید متعلق به یک تامین‌کننده است
    public function supplier(): BelongsTo
    {
        return $this->belongsTo(Supplier::class);
    }

    // یک خرید می‌تواند چندین واریزی داشته باشد
    public function payments(): HasMany
    {
        return $this->hasMany(PurchasePayment::class);
    }

     public function allocations(): HasMany
    {
        return $this->hasMany(SalePurchaseAllocation::class);
    }
}
