<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Purchase;
use App\Models\Sale;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $data = [];

        if ($user->role === 'purchase') {
    $totalPurchases = Purchase::sum('total_amount');
    $totalPayments = Purchase::with('payments')->get()->sum(function ($purchase) {
        return $purchase->payments->sum('amount');
    });
    $totalAllocations = Purchase::with('allocations')->get()->sum(function ($purchase) {
        return $purchase->allocations->sum('allocated_amount');
    });

    $data = [
        'totalPurchases' => $totalPurchases,
        'totalPayments' => $totalPayments,
        'totalAllocations' => $totalAllocations,
        'pendingPurchases' => $totalPurchases - $totalAllocations,
    ];
}

        return view('dashboard.index', compact('data'));
    }
}
